/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather.tracker;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.weather.Weather;

@SideOnly(value=Side.CLIENT)
public class Tracker {
    protected String type() {
        return "VANILLA";
    }

    public final boolean isRaining() {
        return this.getIntensityLevel() > 0.0f;
    }

    public final boolean isThundering() {
        return Tracker.getWorld().func_72911_I();
    }

    public Weather.Properties getWeatherProperties() {
        return Weather.Properties.VANILLA;
    }

    public float getIntensityLevel() {
        return Tracker.getWorld().func_72867_j(1.0f);
    }

    public float getMaxIntensityLevel() {
        return 1.0f;
    }

    public int getNextRainChange() {
        return Tracker.getWorld().func_72912_H().func_76083_p();
    }

    public float getThunderStrength() {
        return Tracker.getWorld().func_72819_i(1.0f);
    }

    public int getNextThunderChange() {
        return Tracker.getWorld().func_72912_H().func_76071_n();
    }

    public int getNextThunderEvent() {
        return 0;
    }

    public float getCurrentVolume() {
        return 0.66f;
    }

    @Nonnull
    public SoundEvent getCurrentStormSound() {
        return Weather.Properties.VANILLA.getStormSound();
    }

    @Nonnull
    public SoundEvent getCurrentDustSound() {
        return Weather.Properties.VANILLA.getDustSound();
    }

    public boolean doVanilla() {
        return true;
    }

    public boolean backgroundThunderPossible() {
        return false;
    }

    public void update() {
    }

    public String toString() {
        Weather.Properties props = this.getWeatherProperties();
        StringBuilder builder = new StringBuilder();
        builder.append("Storm: ").append(props.name());
        builder.append(" ").append(this.getIntensityLevel()).append('/').append(this.getMaxIntensityLevel());
        builder.append(" vanilla: ").append(Tracker.getWorld().func_72867_j(1.0f));
        if (this.backgroundThunderPossible()) {
            builder.append(" thunder event: ").append(this.getNextThunderEvent());
        }
        builder.append(" (").append(this.type()).append(')');
        return builder.toString();
    }

    protected static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

